#include "game.h"
static Game game;
static str start_level = "0";
str start_music = "true_feelings";
//global str start_music = "one_0"
static int start_jump = 0;
static void _fonts_reload(void);
Game* game_global(void) {
    return & game;
}
static void _fonts_reload(void) {
    if (! game.reload_fonts) {
        return ;
    }
    int t = land_get_ticks();
    if (t < game.reload_ts + 30) {
        return ;
    }
    game.reload_fonts = 0;
    game.reload_ts = t;
    float s = land_get_x_scale();
    for (int i = 0; i < 3; i += 1) {
        float fs = 12 + 12 * i;
        fs *= s;
        game.font [i] = land_font_load("URWGothicBook.ttf", fs);
        land_font_scale(game.font [i], 1 / s);
    }
}
void game_init(void) {
    game.reload_fonts = 1;
    game.reload_ts = - 100;
    land_display_title("krampus 2024");
    land_find_data_prefix("data/");
    load_audio();
    game.atlas = land_atlas_new("atlas.txt");
    load_backgrounds();
    level_new(start_level);
    if (start_jump) {
        game.have_switch = 1;
    }
    game.view = land_view_new(0, 0, 800, 450);
}
void game_tick(void) {
    Persist * gc = game.current;
    Player * p = gc->player;
    land_scale_to_fit(800, 450, 256);
    if (land_closebutton()) {
        land_quit();
    }
    if (land_key_pressed(LandKeyEscape)) {
        land_quit();
    }
    float mx, my;
    land_mouse_transformed(& mx, & my);
    game.mx = mx;
    game.my = my;
    if (game.door) {
        game.door_frame += 1;
        int f = 1 + land_div(game.door_frame, 8);
        if (f < 5) {
            land_sprite_set_frame(game.door, f);
        }
        if (game.door_frame == 60) {
            game.door = NULL;
        }
    }
    else if (game.load_next_level) {
        str level = NULL;
        if (game.load_next_level < 0) {
            level = gc->left_door;
        }
        if (game.load_next_level > 0) {
            level = gc->right_door;
        }
        level_new(level);
        gc = game.current;
        p = gc->player;
        if (game.load_next_level < 0) {
            player_place(p, gc->exit_x, gc->exit_y);
            player_look(p, - 1);
        }
        if (game.load_next_level > 0) {
            player_place(p, gc->entry_x, gc->entry_y);
            player_look(p, 1);
        }
        game.load_next_level = 0;
        play(DoorCloseAudio, 1, 0, 1);
    }
    if (game.have_switch) {
        if (land_key(LandKeyLeft) && land_key(LandKeyRight)) {
            if (p->anim == StandingRight || p->anim == StandingLeft) {
                game.changing += 1;
                if (game.changing == 30) {
                    if (p->variant == 0) {
                        p->variant = 1;
                    }
                    else if (p->variant == 1) {
                        p->variant = 2;
                    }
                    else {
                        p->variant = 0;
                    }
                    game.changing = 0;
                }
            }
        }
        else {
            game.changing = 0;
        }
    }
/*
    if land_shift_pressed('A'):
        assert(False)
*/
    if (land_shift_pressed('S')) {
        if (game.slowmo == 0) {
            game.slowmo = 3;
        }
        else {
            game.slowmo = 0;
        }
    }
    if (land_shift_pressed('p')) {
        game.paused = ! game.paused;
    }
/*
    if land_shift_pressed('n'):
        level_new(game.level_number)
*/
    if (land_shift_pressed('f')) {
        land_display_toggle_fullscreen();
    }
    if (land_shift_pressed('c')) {
        gc->tiles_grid->debug_bounds = ! gc->tiles_grid->debug_bounds;
        gc->sprites_grid->debug_bounds = gc->tiles_grid->debug_bounds;
    }
    if (start_jump) {
        if (land_shift_pressed('T')) {
            int w = land_grid_width(gc->tiles_grid);
            p->out_door = 0;
            if (p->x < w / 2) {
                player_place(p, gc->exit_x, gc->exit_y);
            }
            else {
                player_place(p, gc->entry_x, gc->entry_y);
            }
        }
    }
    int kx = 0, ky = 0;
    if (land_key(LandKeyDown)) {
        ky += 1;
    }
    if (land_key(LandKeyLeft)) {
        kx -= 1;
    }
    if (land_key(LandKeyRight)) {
        kx += 1;
    }
    if (land_key(LandKeyUp)) {
        ky -= 1;
    }
    if (game.slowmo) {
        int m = game.slowmo + 1;
        int t = land_get_ticks();
        if (t % m) {
            return ;
        }
    }
    if (game.paused || p->lifes < 0) {
        return ;
    }
    script_tick();
    if (game.cutscene) {
        if (land_key_pressed(LandKeyRight)) {
            if (land_key(LandKeyShift)) {
                script_off();
            }
            else {
                script_skip();
            }
            if (ky) {
                game.no_ky = 1;
            }
        }
        kx = 0;
        ky = 0;
    }
    if (! game.cutscene) {
        if (ky) {
            if (game.no_ky) {
                ky = 0;
            }
        }
        else {
            game.no_ky = 0;
        }
        if (! ky && ! kx) {
            game.idle += 1;
        }
        else {
            game.idle = 0;
        }
        if (p->dead) {
            game.dead += 1;
        }
        else {
            game.dead = 0;
            game.alive += 1;
        }
        if (game.somersault) {
            LandSprite * s = (void *) p;
            game.somersault += 1;
            if (game.somersault == 30) {
                game.somersault = 0;
                s->angle = 0;
            }
            else {
                s->angle = game.somersault * 2 * pi / 30;
                if (p->left) {
                    s->angle = - s->angle;
                }
            }
        }
        if (game.dead > 60) {
            if (ky) {
                ky = 0;
                game.no_ky = 1;
                game.dead = 0;
                game.alive = 0;
                p->dead = 0;
                player_place(p, game.last_gx, game.last_gy);
            }
        }
        game.input_kx = kx;
        game.input_ky = ky;
    }
    {
        LandArrayIterator __iter0__ = LandArrayIterator_first(gc->players);
        for (Player * a = LandArrayIterator_item(gc->players, &__iter0__); LandArrayIterator_next(gc->players, &__iter0__); a = LandArrayIterator_item(gc->players, &__iter0__)) {
            if (a->removed) {
                continue;
            }
            player_tick(a);
        }
    }
    if (p->ground) {
        if (game.feign_dead) {
            game.feign_dead = 0;
            p->dead = 1;
            game.dead = 30 /* can stand up again right away when feigned */;
        }
        game.last_gx = p->x - p->dx;
        game.last_gy = p->y - p->dy;
    }
    game.ticks += 1;
}
void game_draw(void) {
    Persist * gc = game.current;
    Player * p = gc->player;
    LandView * view = game.view;
    land_scale_to_fit(800, 450, 0);
    if (land_was_resized()) {
        game.reload_fonts = 1;
    }
    _fonts_reload();
    land_unclip();
    land_clear(.1, .1, .1, 1);
    land_clip_transformed(0, 0, 800, 450);
    land_view_ensure_visible(game.view, p->x, p->y, 32 * 6, 32 * 6);
    land_view_ensure_inside_grid(game.view, gc->tiles_grid);
    land_map_draw(gc->level, game.view);
    if (game.dead > 60) {
        float v = game.dead - 60;
        v = v / 300;
        if (v > 1) {
            v = 1;
        }
        land_color(0, 0, 0, v);
        land_filled_rectangle(0, 0, 800, 450);
    }
    if (p->lifes < 0) {
        land_text_background(land_color_rgba(0.4, 0.4, 0.4, 0.4), 4);
        land_color(0, 0, 0, 1);
        land_text_pos(400, 225);
        land_font_set(game.font [2]);
        land_print_middle("Game Over");
        land_text_background_off();
    }
    if (0) {
        land_text_background(land_color_rgba(0.4, 0.4, 0.4, 0.4), 4);
        land_font_set(game.font [0]);
        land_text_pos(800 - 8, 8);
        land_print_multiline_right("FPS: %d\n"
            "    tiles: %d sprites: %d\n"
            "    speed %.1f/%.1f", land_get_current_fps(), gc->tiles_grid->stats_drawn, gc->sprites_grid->stats_drawn, p->dx, p->dy);
        land_text_background_off();
    }
    if (game.cutscene) {
        land_text_background(land_color_rgba(0.4, 0.4, 0.4, 0.4), 4);
        land_color(0, 0, 0, 1);
        land_text_pos(4, 450 - 4);
        land_font_set(game.font [0]);
        land_print_bottom("Press RIGHT to skip text");
        land_text_background_off();
    }
    else if (land_equals(gc->level_number, "0")) {
        land_text_background(land_color_rgba(0.4, 0.4, 0.4, 0.4), 4);
        land_color(0, 0, 0, 1);
        land_text_pos(4, 450 - 4);
        land_font_set(game.font [0]);
        land_print_bottom("F toggle fullscreen");
        land_text_background_off();
    }
    if (1) {
        str icos [] = {"heart_subdiv", "ruby", "beryl", "citrine", "emerald", "aquamarine", "sapphire", "amethyst", "diamond2", "opal", "carnelian"};
        str cols [] = {"red", "crimson", "orange", "yellow", "seagreen", "aquamarine", "blue", "medium purple", "light yellow", "silver", "pink"};
        int * gv = gc->gems;
        int vals [] = {p->lifes, gv [0], gv [1], gv [2], gv [3], gv [4], gv [5], gv [6], gv [7], gv [8], gv [9], gv [10]};
        int x = 4;
        for (int i = 0; i < 11; i += 1) {
            if (vals [i] <= 0) {
                continue;
            }
            land_color_set_named(cols [i]);
            LandSpriteType * st = get_animation_type(icos [i], 0);
            int t = game.ticks;
            LandSpriteTypeAnimation * sta = (void *) st;
            land_animation_draw_scaled(sta->animation, x + 8, 4 + 8, .25, .25, (land_div(t, 4)) & 31);
            land_font_set(game.font [0]);
            land_text_pos(x + 16 + 4, 4);
            land_print("%d", vals [i]);
            x = land_text_x() + 16;
        }
    }
    if (0) {
        land_color(1, 1, 1, 1);
        int i = game.trail0;
        while (i != game.trail) {
            land_plot(game.trail_x [i] - view->scroll_x, game.trail_y [i] - view->scroll_y);
            i += 1;
            if (i == 300) {
                i = 0;
            }
        }
    }
    LandList * visible = land_sprites_grid_get_rectangle_exact(gc->sprites_grid, view->scroll_x, view->scroll_y, view->scroll_x + 800, view->scroll_y + 450);
    if (visible) {
        {
            LandListIterator __iter0__ = LandListIterator_first(visible);
            for (Player * pl = LandListIterator_item(visible, &__iter0__); LandListIterator_next(visible, &__iter0__); pl = LandListIterator_item(visible, &__iter0__)) {
                if (pl->text && pl->text [0]) {
                    LandSprite * s = & pl->super.super;
                    print_speech_bubble(pl->x, pl->y - s->type->h - 32, pl->text);
                    if (game.ticks > pl->text_t) {
                        land_free(pl->text);
                        pl->text = NULL;
                    }
                }
            }
        }
        land_list_destroy(visible);
    }
}
void game_done(void) {
    ;
}
